/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.CachedMetamethod;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.function.LuaFunction;

public abstract class LuaValue
extends Varargs {
    private final int type;

    protected LuaValue(int type) {
        this.type = type;
    }

    public final int type() {
        return this.type;
    }

    public final String typeName() {
        return Constants.TYPE_NAMES[this.type];
    }

    public final LuaString luaTypeName() {
        return Constants.TYPE_NAMES_LUA[this.type];
    }

    public final boolean isNil() {
        return this == Constants.NIL;
    }

    public boolean isNumber() {
        return false;
    }

    public final boolean isString() {
        return this.type == 4 || this.type == 3;
    }

    public final boolean isThread() {
        return this.type == 8;
    }

    public final boolean toBoolean() {
        return this != Constants.NIL && this != Constants.FALSE;
    }

    public double toDouble() {
        return Double.NaN;
    }

    public int toInteger() {
        return 0;
    }

    @Override
    public String toString() {
        return String.valueOf(ErrorFactory.typeName(this)) + ": " + Integer.toHexString(this.hashCode());
    }

    public LuaValue toNumber() {
        return Constants.NIL;
    }

    public LuaValue toLuaString() {
        return Constants.NIL;
    }

    public final boolean optBoolean(boolean defval) throws LuaError {
        return this == Constants.NIL ? defval : this.checkBoolean();
    }

    public final double optDouble(double defval) throws LuaError {
        return this == Constants.NIL ? defval : this.checkDouble();
    }

    public final LuaFunction optFunction(LuaFunction defval) throws LuaError {
        return this == Constants.NIL ? defval : this.checkFunction();
    }

    public final int optInteger(int defval) throws LuaError {
        return this == Constants.NIL ? defval : this.checkInteger();
    }

    public final long optLong(long defval) throws LuaError {
        return this == Constants.NIL ? defval : this.checkLong();
    }

    public final LuaNumber optNumber(LuaNumber defval) throws LuaError {
        return this == Constants.NIL ? defval : this.checkNumber();
    }

    public final String optString(String defval) throws LuaError {
        return this == Constants.NIL ? defval : this.checkString();
    }

    public final LuaString optLuaString(LuaString defval) throws LuaError {
        return this == Constants.NIL ? defval : this.checkLuaString();
    }

    public final LuaTable optTable(LuaTable defval) throws LuaError {
        return this == Constants.NIL ? defval : this.checkTable();
    }

    public final LuaThread optThread(LuaThread defval) throws LuaError {
        return this == Constants.NIL ? defval : this.checkThread();
    }

    public final LuaValue optValue(LuaValue defval) {
        return this == Constants.NIL ? defval : this;
    }

    public boolean checkBoolean() throws LuaError {
        throw ErrorFactory.argError(this, "boolean");
    }

    public double checkDouble() throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public LuaFunction checkFunction() throws LuaError {
        throw ErrorFactory.argError(this, "function");
    }

    public int checkInteger() throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public long checkLong() throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public LuaNumber checkNumber() throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public LuaNumber checkNumber(String msg) throws LuaError {
        throw new LuaError(msg);
    }

    public String checkString() throws LuaError {
        throw ErrorFactory.argError(this, "string");
    }

    public LuaString checkLuaString() throws LuaError {
        throw ErrorFactory.argError(this, "string");
    }

    public LuaTable checkTable() throws LuaError {
        throw ErrorFactory.argError(this, "table");
    }

    public LuaThread checkThread() throws LuaError {
        throw ErrorFactory.argError(this, "thread");
    }

    @Override
    public LuaValue arg(int index) {
        return index == 1 ? this : Constants.NIL;
    }

    @Override
    public int count() {
        return 1;
    }

    @Override
    @Deprecated
    public LuaValue first() {
        return this;
    }

    @Override
    public void fill(LuaValue[] array, int offset) {
        array[offset] = this;
    }

    public LuaTable getMetatable(LuaState state) {
        return null;
    }

    public void setMetatable(LuaState state, LuaTable metatable) throws LuaError {
        throw ErrorFactory.argError(this, "table");
    }

    public final LuaValue metatag(LuaState state, LuaValue tag) {
        LuaTable mt = this.getMetatable(state);
        return mt == null ? Constants.NIL : mt.rawget(tag);
    }

    public final LuaValue metatag(LuaState state, CachedMetamethod tag) {
        LuaTable mt = this.getMetatable(state);
        return mt == null ? Constants.NIL : mt.rawget(tag);
    }

    protected static final class PairVarargs
    extends Varargs.DepthVarargs {
        private final LuaValue v1;
        private final Varargs v2;

        public PairVarargs(LuaValue v1, Varargs v2) {
            super(PairVarargs.depth(v2) + 1);
            this.v1 = v1;
            this.v2 = v2;
        }

        @Override
        public LuaValue arg(int i) {
            return i == 1 ? this.v1 : this.v2.arg(i - 1);
        }

        @Override
        public int count() {
            return 1 + this.v2.count();
        }

        @Override
        public LuaValue first() {
            return this.v1;
        }

        @Override
        public void fill(LuaValue[] array, int offset) {
            array[offset] = this.v1;
            this.v2.fill(array, offset + 1);
        }
    }

    protected static final class ArrayVarargs
    extends Varargs.DepthVarargs {
        private final LuaValue[] v;
        private final Varargs r;

        public ArrayVarargs(LuaValue[] v, Varargs r) {
            super(ArrayVarargs.depth(r) + 1);
            this.v = v;
            this.r = r;
        }

        @Override
        public LuaValue arg(int i) {
            return i >= 1 && i <= this.v.length ? this.v[i - 1] : this.r.arg(i - this.v.length);
        }

        @Override
        public int count() {
            return this.v.length + this.r.count();
        }

        @Override
        public LuaValue first() {
            return this.v.length > 0 ? this.v[0] : this.r.first();
        }

        @Override
        public void fill(LuaValue[] array, int offset) {
            System.arraycopy(this.v, 0, array, offset, this.v.length);
            this.r.fill(array, offset + this.v.length);
        }
    }
}

